/*:
 * @target MZ
 * @plugindesc Options Overlay Input Lock v1.2 — オプション重ね表示中に下層への入力を完全遮断（wheel非依存）
 * @author HS
 * @help
 * 使い方：HS_OptionsOverlay.js の「後」に配置してください。
 * - オプション重ね表示中（Scene._hsOptionsWin が存在中）は、
 *   ・文章送り（Window_Message）
 *   ・マップタッチ（Scene_Map）
 *   ・画面クリック/ドラッグ/右クリック/ホイール など
 *   の下層反応をブロックします（wheelY等は参照しません）。
 * - ピクチャ系ボタンで独自にTouchInputを読むものは、入口に
 *     if (window.HS?.isOptionsOverlayOpen?.()) return;
 *   を1行足すと確実です。
 */
(() => {
  'use strict';

  // ====== 状態参照 ======
  const isOpen = () => !!SceneManager._scene?._hsOptionsWin;

  // 他プラグインから参照できる便利フラグ
  window.HS = window.HS || {};
  HS.isOptionsOverlayOpen = isOpen;

  // ====== 透明ブロッカー（ポインタ/ホイールを最上層で食う） ======
  const makeBlocker = () => {
    const g = new PIXI.Graphics();
    g.beginFill(0x0, 0.001).drawRect(0, 0, Graphics.width, Graphics.height).endFill();
    g.interactive = true;         // これで下層への pointer を止められる
    g.interactiveChildren = true; // 念のため
    g.zIndex = 9e6;
    const stop = e => { e?.stopPropagation?.(); e?.preventDefault?.(); };
    g.on('pointerdown', stop).on('pointerup', stop).on('pointermove', stop)
     .on('pointertap', stop).on('rightdown', stop).on('rightup', stop).on('click', stop);
    // PIXIにwheelイベントが渡る環境ならこれで止まる（無い環境でも問題なし）
    g.on?.('wheel', stop);
    return g;
  };

  // Canvas直の wheel も捕まえて止める（存在チェック付き）
  const addWheelTrap = (scene) => {
    const view = Graphics?._app?.view || Graphics?.app?.view || document.getElementById('GameCanvas') || null;
    if (!view) return;
    if (scene._hsWheelTrap) return; // 二重登録防止
    const onWheel = (e) => { if (isOpen()) { e.stopPropagation(); e.preventDefault(); } };
    view.addEventListener('wheel', onWheel, { passive:false, capture:true });
    scene._hsWheelTrap = () => view.removeEventListener('wheel', onWheel, { capture:true });
  };

  // ====== オプション開閉に合わせてブロッカーを付け外し ======
  const _SceneBase_update = Scene_Base.prototype.update;
  Scene_Base.prototype.update = function() {
    _SceneBase_update.apply(this, arguments);
    addWheelTrap(this);
    if (isOpen()) {
      if (!this._hsInputBlocker) {
        this._hsInputBlocker = makeBlocker();
        this.addChild(this._hsInputBlocker);
        this.sortChildren?.();
      }
      // 念のため毎フレーム、入力状態を掃除（存在チェック付き）
      try { window.Input?.clear?.(); } catch(_) {}
      try { window.TouchInput?.clear?.(); } catch(_) {}
    } else if (this._hsInputBlocker) {
      this.removeChild(this._hsInputBlocker);
      this._hsInputBlocker.destroy({ children:true });
      this._hsInputBlocker = null;
      if (this._hsWheelTrap) { this._hsWheelTrap(); this._hsWheelTrap = null; }
    }
  };

  // ====== 文章送りのブロック ======
  const _WM_isTriggered = Window_Message.prototype.isTriggered;
  Window_Message.prototype.isTriggered = function() {
    if (isOpen()) return false;
    return _WM_isTriggered.apply(this, arguments);
  };
  const _WM_processInput = Window_Message.prototype.processInput;
  Window_Message.prototype.processInput = function() {
    if (isOpen()) return false;
    return _WM_processInput.apply(this, arguments);
  };

  // ====== マップタッチのブロック ======
  const _SM_processMapTouch = Scene_Map.prototype.processMapTouch;
  Scene_Map.prototype.processMapTouch = function() {
    if (isOpen()) return;
    _SM_processMapTouch.apply(this, arguments);
  };
})();

